// Simple Java Swing application to front-end a Perfect Developer program

package Tutorial;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import Ertsys.*;

// This is the top-level class
public class TutorialExamples implements ActionListener
{
    JFrame appFrame;				            					// Swing object for the entire window
    JPanel appPanel;															// Swing object for the panel
    JTextField textInput1, textInput2;						// Swing objects for the parameter input text boxes
    JLabel status;																// Swing object for	displaying the result
    JButton button1, button2, button3, button4;  	// Buttons that the user can press
		Application backend;													// 'Perfect' backend

    // Constructor
    public TutorialExamples()
		{
			// Create the back end
			backend = new Application();

			// Create the frame and container.
			appFrame = new JFrame("Tutorial example");
			appPanel = new JPanel();
			appPanel.setLayout(new GridLayout(0, 2, 10, 10));
			appPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

			// Add the widgets.
			addWidgets();

			// Add the panel to the frame.
			appFrame.getContentPane().add(appPanel, BorderLayout.CENTER);

			// Exit when the window is closed.
  		appFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

			// Show the app.
			appFrame.pack();
			appFrame.setVisible(true);
    }

    // Create and add the widgets for app.
    private void addWidgets()
		{
			// Create widgets.
			textInput1 = new JTextField(20);
			textInput2 = new JTextField(20);
			status = new JLabel();
			button1 = new JButton("Call 'function1'");
			button2 = new JButton("Call 'function2'");
			button3 = new JButton("Call 'schema1' and get result");
			button4 = new JButton("Call 'schema2' and get result");

			// Listen to events from Convert button.
			button1.addActionListener(this);
			button2.addActionListener(this);
			button3.addActionListener(this);
			button4.addActionListener(this);

			// Add widgets to container.
			appPanel.add(new JLabel("Parameter 1:", JLabel.RIGHT));
			appPanel.add(textInput1);
			appPanel.add(new JLabel("Parameter 2:", JLabel.RIGHT));
			appPanel.add(textInput2);
			appPanel.add(button1);
			appPanel.add(button2);
			appPanel.add(button3);
			appPanel.add(button4);
			appPanel.add(new JLabel("Result:", JLabel.RIGHT));
			appPanel.add(status);
    }

    // Implementation of ActionListener interface.
    public void actionPerformed(ActionEvent event)
		{
			String param1 = textInput1.getText();
			String param2 = textInput2.getText();
			if (event.getSource() == button1)
			{
				status.setText(_eSystem._lJavaString(backend.function1(_eSystem._lString(textInput1.getText()), (char)0, _eSystem._lString(textInput2.getText()), (char)0)));
			}
			else if (event.getSource() == button2)
			{
				status.setText(_eSystem._lJavaString(backend.function2(_eSystem._lString(textInput1.getText()), (char)0, _eSystem._lString(textInput2.getText()), (char)0)));
			}
			else if (event.getSource() == button3)
			{
				backend.schema1(_eSystem._lString(textInput1.getText()), (char)0, _eSystem._lString(textInput2.getText()), (char)0);
				status.setText(_eSystem._lJavaString(backend.getResult()));
			}
			else if (event.getSource() == button4)
			{
				backend.schema2(_eSystem._lString(textInput1.getText()), (char)0, _eSystem._lString(textInput2.getText()), (char)0);
				status.setText(_eSystem._lJavaString(backend.getResult()));
			}
			else status.setText("Unknown event or return code");
		}

    // main method
    public static void main(String[] args)
		{
			// Set the look and feel.
			try
			{
			  UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
			} catch(Exception e) {}

			TutorialExamples applicationObject = new TutorialExamples();
    }
}

// End
